<?php

if (!defined('_PS_VERSION_'))
	exit;
/*****************************************************************************
 |  # Proyecto: REGRESIVE OFFERTA- PrestaShop Module -                       |
 |  # INFO: info@goldenfoxi.com                                              |
 |===========================================================================|
 | Copyright (c) 2012 www.goldenfoxi.com - Todos Los Derechos Reservados -   |
 |===========================================================================| 
                    ACTUALIZADO 14 AGOSTO 2012 
 *****************************************************************************/	
 
class RegresiveOffer extends Module
{
	private $_html = '';
	private $_postErrors = array();

    	function __construct()
	{
		$this->name = 'regresiveoffer';
		$this->tab = 'pricing_promotion';
		$this->version = '1.2';
		$this->author = 'www.goldenfoxi.com';
		$this->need_instance = 0;

		parent::__construct();

		$this->displayName = $this->l('Ofertas Regresivas');
		$this->description = $this->l('Rotador de Ofertas con cuenta regresiva.');
	}

	public function install()
	{
		return (parent::install() 
		AND $this->registerHook('displayHome')  
		AND $this->registerHook('header'));
	}

	public function getContent()
	{
		$output = '<h2>'.$this->displayName.'</h2>';
		if (Tools::isSubmit('submitRegresive'))
		{
			Configuration::updateValue('PS_BLOCK_REGRESIVE_DISPLAY', (int)(Tools::getValue('regresive_display')));
			$output .= '<div class="conf confirm">
			<img src="../img/admin/ok.gif" alt="'.$this->l('ok').'" />'.$this->l('Datos actualizados.').'</div>';
		}
		return $output.$this->displayForm();
	}

	public function displayForm()
	{
		return '
		<form action="'.Tools::safeOutput($_SERVER['REQUEST_URI']).'" method="post">
			<fieldset>
				<legend><img src="'.$this->_path.'logo.gif" alt="" title="" />
				'.$this->l('Configuracion - www.goldenfoxi.com -').'</legend>
				<label>'.$this->l('Mostrar este bloque siempre').'</label>
				<div class="margin-form">
					<input type="radio" name="regresive_display" id="display_on" value="1" '.(Tools::getValue('regresive_display', Configuration::get('PS_BLOCK_REGRESIVE_DISPLAY')) ? 'checked="checked" ' : '').'/>
					<label class="t" for="display_on"> <img src="../img/admin/enabled.gif" alt="'.$this->l('Enabled').'" title="'.$this->l('Activo').'" /></label>
					<input type="radio" name="regresive_display" id="display_off" value="0" '.(!Tools::getValue('regresive_display', Configuration::get('PS_BLOCK_REGRESIVE_DISPLAY')) ? 'checked="checked" ' : '').'/>
					<label class="t" for="display_off"> <img src="../img/admin/disabled.gif" alt="'.$this->l('No activo').'" title="'.$this->l('Disabled').'" /></label>
					<p class="clear">'.$this->l('Mostrar este bloque aunque no haya productos disponibles en Stock.').'</p>
				</div>
				<center><input type="submit" name="submitRegresive" value="'.$this->l('Save').'" class="button" /></center>
			</fieldset>
		</form>';
	}


  public function hookDisplayHome($params)
	   {
if (Configuration::get('PS_CATALOG_MODE'))return ;
		global $smarty, $cookie;
               
                    $specials = Product::getPricesDrop((int)($params['cookie']->id_lang));
                foreach($specials as $special){
                        $special['priceWithoutReduction_tax_excl']= Tools::ps_round($special['price_without_reduction'], 2);
                                         }
		$smarty->assign(array(
			'specials' => $specials,
			'this_path' => $this->_path,
			'mediumSize' => Image::getSize('home')));
		return $this->display(__FILE__, 'regresiveoffer.tpl');
	   }

	public function hookHeader($params)
		{
			if (Configuration::get('PS_CATALOG_MODE'))
				return ;
			Tools::addCSS(($this->_path).'css/regresiveoffer.css', 'all');
			Tools::addJS(($this->_path).'js/regresivo.js');
		}
}
?>