<?php

class HomeFeaturedCarousel extends Module
{
	private $_html = '';
	private $_postErrors = array();

	function __construct()
	{
		$this->name = 'homefeaturedcarousel';
		$this->tab = 'Home';
		$this->version = 0.31;

		parent::__construct(); // The parent construct is required for translations

		$this->page = basename(__FILE__, '.php');
		$this->displayName = $this->l('Featured Products on the homepage as Flash Carousel');
		$this->description = $this->l('Displays Featured Products in the middle of your homepage as Flash Carousel (Module Errors Fixed By Sachintha, Sort addon by Toebiash)');
	}

	function install()
	{
		if (!Configuration::updateValue('HOME_FEATURED_CAROUSEL_NBR', 10) OR !parent::install() OR !$this->registerHook('home'))
		return false;
		if (!Configuration::updateValue('HOME_FEATURED_CAROUSEL_SORT', 0))
			return false;
		return true;
	}

	public function getContent()
	{
		$output = '<h2>'.$this->displayName.'</h2>';
		if (Tools::isSubmit('submitHomeFeaturedCarousel'))
		{
			$nbr = intval(Tools::getValue('nbr'));
			$sort = intval(Tools::getValue('sort'));
			if (!$nbr OR $nbr <= 0 OR !Validate::isInt($nbr))
				$errors[] = $this->l('Invalid number of product');
			else
				Configuration::updateValue('HOME_FEATURED_CAROUSEL_NBR', $nbr);
				Configuration::updateValue('HOME_FEATURED_CAROUSEL_SORT', $sort);
			if (isset($errors) AND sizeof($errors))
				$output .= $this->displayError(implode('<br />', $errors));
			else
				$output .= $this->displayConfirmation($this->l('Settings updated'));
		}
		return $output.$this->displayForm();
	}

	public function displayForm()
	{
		$output = '
		<form action="'.$_SERVER['REQUEST_URI'].'" method="post">
			<fieldset><legend><img src="'.$this->_path.'logo.gif" alt="" title="" />'.$this->l('Settings').'</legend>
				<label>'.$this->l('Number of product displayed').'</label>
				<div class="margin-form">
					<input type="text" size="5" name="nbr" value="'.Tools::getValue('nbr', Configuration::get('HOME_FEATURED_CAROUSEL_NBR')).'" />
					<p class="clear">'.$this->l('The number of products displayed on homepage (default: 10)').'</p>
					
				</div>
				
				<label>'.$this->l('Choice of sort').'</label>
				<div class="margin-form">
					<select name="sort" id="sort">
						<option value="0" '.(Configuration::get('HOME_FEATURED_CAROUSEL_SORT') == 0 ? 'selected' : '').'>'.$this->l('No Sort - Sort by Back Office => Catalogue -> Position').'</option>
						<option value="1" '.(Configuration::get('HOME_FEATURED_CAROUSEL_SORT') == 1 ? 'selected' : '').'>'.$this->l('Random').'</option>
						<option value="2" '.(Configuration::get('HOME_FEATURED_CAROUSEL_SORT') == 2 ? 'selected' : '').'>'.$this->l('Price Asc').'</option>
						<option value="3" '.(Configuration::get('HOME_FEATURED_CAROUSEL_SORT') == 3 ? 'selected' : '').'>'.$this->l('Price Desc').'</option>
						<option value="4" '.(Configuration::get('HOME_FEATURED_CAROUSEL_SORT') == 4 ? 'selected' : '').'>'.$this->l('Last update in first').'</option>
						<option value="5" '.(Configuration::get('HOME_FEATURED_CAROUSEL_SORT') == 5 ? 'selected' : '').'>'.$this->l('Last add in first').'</option>
						<option value="6" '.(Configuration::get('HOME_FEATURED_CAROUSEL_SORT') == 6 ? 'selected' : '').'>'.$this->l('Alphabetical').'</option>
					</select>
				</div>

				<center><input type="submit" name="submitHomeFeaturedCarousel" value="'.$this->l('Save').'" class="button" /></center>
			</fieldset>
		</form>';
		return $output;
	}

	function hookHome($params)
	{
		global $smarty;
		$category = new Category(2);
		$nb = intval(Configuration::get('HOME_FEATURED_CAROUSEL_NBR'));
		$sort = intval(Configuration::get('HOME_FEATURED_CAROUSEL_SORT'));
		switch ($sort) {
		    case '0':
			$products = $category->getProducts(intval($params['cookie']->id_lang), 1, ($nb ? $nb : 10));
			break;
		    case '1':
			$products = $category->getProducts(intval($params['cookie']->id_lang), 1, 1000);
			shuffle($products);
			array_splice($products, ($nb ? $nb : 10));
			break;
		    case '2':
			$products = $category->getProducts(intval($params['cookie']->id_lang), 1, ($nb ? $nb : 10), 'price', 'ASC');  
			break;
		    case '3':
			$products = $category->getProducts(intval($params['cookie']->id_lang), 1, ($nb ? $nb : 10), 'price', 'DESC');  
			break;
		    case '4':
			$products = $category->getProducts(intval($params['cookie']->id_lang), 1, ($nb ? $nb : 10), 'date_upd', 'DESC');  
			break;
		    case '5':
			$products = $category->getProducts(intval($params['cookie']->id_lang), 1, ($nb ? $nb : 10), 'date_add', 'DESC');  
			break;
		    case '6':
			$products = $category->getProducts(intval($params['cookie']->id_lang), 1, ($nb ? $nb : 10), 'name', 'ASC');  
			break;
		    default:
			$products = $category->getProducts(intval($params['cookie']->id_lang), 1, ($nb ? $nb : 10));
			break;
		}		
		$smarty->assign(array(
			'allow_buy_when_out_of_stock' => Configuration::get('PS_ORDER_OUT_OF_STOCK', false),
			'max_quantity_to_allow_display' => Configuration::get('PS_LAST_QTIES'),
			'category' => $category,
			'products' => $products,
			'currency' => new Currency(intval($params['cart']->id_currency)),
			'lang' => Language::getIsoById(intval($params['cookie']->id_lang)),
			'productNumber' => sizeof($products)
		));
		return $this->display(__FILE__, 'homefeaturedcarousel.tpl');
	}

}
